﻿/*
WHAT THIS DOES:
	converts the contents within []
HANDLES:
	evaluate variable paths
	create objects
RETURNS:
	
*/
parseVariablePaths = function( input )
{
	var output = input;
	#include "gameFunctions/getPathValue.as"
	var bracketStartAt = 0;
	while( output.indexOf("[", bracketStartAt)>-1 )
	{// while:  A variable path exists  &  this is a string
		// find [
		var bracketStartAt = output.indexOf("[", bracketStartAt);
		// find ]
		var bracketEndAt = output.indexOf("]", bracketStartAt);
		// find (
		var paramStartAt = output.indexOf("(", bracketStartAt);
		// end at ( else ]
		var pathEndAt = (paramStartAt==-1  ||  paramStartAt>bracketEndAt) ? bracketEndAt : paramStartAt;		// end at ( if it's present within []
		// get path in between them
		var path = output.substring( bracketStartAt+1, pathEndAt );
		var pathType = "variable";		// default type
		
		// detect objects
		var objectDetect = path.indexOf(":");
		if(objectDetect>-1)
			var pathType = "object";
		
		
		
		if(pathType == "object")
		{// if:  this is an object string
			var getTrueValue = function( thisValue )
			{
				var valueType = "string";
				if( !isNaN(thisValue) )
					var output = Number(thisValue);
				else if(thisValue=="true"  ||  thisValue==true)
					var output = true; 
				else if(thisValue=="false"  ||  thisValue==false)
					var output = false;
				else
					var output = String(thisValue);
				return output;
			}// getTrueValue()
			
			var newObj = {};
			var object_array = path.split(",");
			for(var i=0; i<object_array.length; i++){
				var this_str = object_array[i];
				var splitAt = this_str.indexOf(":");
				var varName = this_str.substr(0,splitAt);
				var value = this_str.substr(splitAt+1);
				value = getTrueValue( value );
				newObj[varName] = value;
			}//  for:  each variable described
			output = newObj;
		}// if:  this is an object string
		
		
		
		if(pathType == "variable")
		{// if:  path is a variable or function
			// get value of path
			var pathValue = getPathValue( path, "RAM" );
			// do function call if relevant
			if(paramStartAt!=-1  &&  paramStartAt<bracketEndAt)
			{// if:  it's being called as a function			example:		[myObj.myVar()]
				var paramEndAt = output.indexOf(")", paramStartAt);
				if(paramEndAt!=-1  &&  paramEndAt<bracketEndAt)
				{// if:  there is a )
					var param_str = output.substring( paramStartAt+1, paramEndAt );
					var param_array = param_str.split(",");
					// // 	params that are strings cannot contain:		[ ] ( ) ,
					// // 	"" are not used in parameters, so be careful with spaces in all params, regardless of type
					// do function call
					var functionResult = pathValue.apply( this, param_array );
					// replace [path] with the function's result
					var beginning_str = output.substr(0, bracketStartAt);
					var end_str = output.substr(bracketEndAt+1);
					output = beginning_str + functionResult + end_str;
					// "undefined" -> undefined
					output = (output=="undefined") ? undefined : output;
				}// if:  there is a )
			}// if:  it's being called as a function			example:		[myVar(param1,param2)]
			else
			{// if:  not being called.			no () present
				// replace [path] with value
				var beginning_str = output.substr(0, bracketStartAt);
				var end_str = output.substr(bracketEndAt+1);
				output = beginning_str + pathValue + end_str;
			}// if:  not being called.			no () present
			// update bracketStartAt for next detection
			bracketStartAt++;
		}// while:  A variable path exists  &  this is a string
	}// if:  path is a variable or function
	
	
	
	return output;
}// parseVariablePaths()